IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Clientes_Deuda_Resumen') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Clientes_Deuda_Resumen
END
GO

CREATE PROCEDURE [dbo].[CPJ_Clientes_Deuda_Resumen]	@pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON

/*Parametros*/
DECLARE @pFechaDesde			DATETIME,
		@pFechaHasta			DATETIME,
		@pId_Unid_Negocio       VARCHAR(10),
		@pFiltrar_con_saldo     TINYINT,
		@pClientes_activos      TINYINT,
		@pFormato			    CHAR(10),  -- C=Total x Cliente F=Total por Factura P=Total por Producto X-Comparativo  TP-Total por producto TPM-Total por producto/mes 
		@pId_Cliente            INT,
		@pId_Cliente_Tit		INT,
		@pFiltroFecha           TINYINT,
		@pEquate                SMALLINT,
		@pUsuario               INT
/*Fin de Parametros*/

	
		/*Seteo Parametros*/
		SET @pId_Unid_Negocio			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Unid_Negocio')),'')
		SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
		SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())
		SET @pFiltrar_con_saldo			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Filtrar_con_saldo')),0)
		SET @pClientes_activos			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Clientes_activos')),0)
		SET @pFormato					= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Formato')),'')
		SET @pId_Cliente				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Cliente')),0)
		SET @pFiltroFecha		    	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltroFecha')),0)
		SET @pEquate		        	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Equate')),0)
		SET @pUsuario		        	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Usuario')),0)
		SET @pEquate					= 400
		/*Fin Seteo Parametros*/

		/*Declaro Variables Locales*/
		DECLARE  @Id_Producto					VARCHAR(14)
				,@Id_Proveedor					INT
				,@Razon_Social					VARCHAR(100)
				,@Cuit							VARCHAR(13)
				,@Id_Iva						CHAR(3)
				,@Id_Alias_Cta_Cont				INT
				,@Id_Cta_Contable_H				INT
				,@Porc_Comision_Prov			DECIMAL(7,2) 
				,@Importe						DECIMAL(12,2) 
				,@IMPORTE_CREDITO				DECIMAL(12,2) 
				,@ID_TIPO_CBTE					CHAR(4) 
				,@FECHA							DATETIME
				,@Imp_prod_siva					DECIMAL(12,2) 
				,@TRANS							INT
				,@Id_Cliente_Externo			VARCHAR(14)
				,@Id_Cta_Banco					INT
				,@Id_Cliente					INT
				,@EXISTE_TAG					INT
				,@Cli_Ref_CtaCte_Agrup			TINYINT

		DECLARE @Sql		    VARCHAR(MAX)
		DECLARE @SqlSaldo	    VARCHAR(MAX)
		DECLARE @SqlSelect		VARCHAR(MAX)
		DECLARE @SqlSelectRec	VARCHAR(MAX)
		DECLARE @SqlFrom	    VARCHAR(MAX)
		DECLARE @SqlFromRec	    VARCHAR(MAX)
		DECLARE @SqlWhere		VARCHAR(MAX)
		DECLARE @SqlWhereFac	VARCHAR(MAX)
		DECLARE @SqlWhereRec	VARCHAR(MAX)
		/*Fin Variables Locales*/

		SET @Sql	    = ''
		SET @SqlSaldo	= ''
		SET @SqlSelect	= ''
		SET @SqlSelectRec	= ''
		SET @SqlFrom	= ''
		SET @SqlFromRec	= ''
		SET @SqlWhere	= ''
		SET @SqlWhereFac	= ''
		SET @SqlWhereRec	= ''

		SET @FECHA		= (SELECT CAST(GETDATE() AS DATE))
		SET @EXISTE_TAG = 0

		SELECT ID_UNID_NEGOCIO 
			INTO #UN FROM Empresas_Unid_Negocios

		IF(CAST(@pId_Unid_Negocio AS INT)) <> 0
			DELETE #UN WHERE ID_UNID_NEGOCIO <> @pId_Unid_Negocio


		CREATE TABLE #ACTIVO (ACTIVO TINYINT)
			INSERT INTO #ACTIVO (ACTIVO) VALUES (1)

		IF(@pClientes_activos) <> 1
			INSERT INTO #ACTIVO (ACTIVO) VALUES (0)

        SET @Cli_Ref_CtaCte_Agrup = CONVERT(TINYINT,dbo.CF_xParam('Cli_Ref_CtaCte_Agrup'))
		SELECT @pId_Cliente_Tit = Id_Cliente_Ref FROM Clientes WHERE Id_Cliente = @pId_Cliente
		IF ISNULL(@pId_Cliente_Tit,0) = 0 
			SET @pId_Cliente_Tit = @pId_Cliente

		/************************************************ SQL SELECT ************************************************/
		CREATE TABLE #Result (
			Id_Cliente			INT
			,Razon_Social		VARCHAR(100)
			,Id_Trans			INT
			,Id_Tipo_Cbte		CHAR(4)
			,Fecha				DATETIME
			,Fecha_Venc			DATETIME
			,Cbte_Descrip		VARCHAR(100)
			,Nro_Cuota			INT
			,Id_Producto		VARCHAR(14)
			,Producto			VARCHAR(150)
			,Saldo				DECIMAL(16,2)
			,Id_Cliente_Ref		INT	
			)

		IF @pFormato IN ('','C','X')
			SET @SqlSelect = 'INSERT INTO #Result (Id_Cliente,Razon_Social,Id_Cliente_Ref,Saldo) 
				SELECT C.Id_Cliente, C.Razon_Social,C.Id_Cliente_Ref, (CC.Saldo  * F.Cotizacion  ) AS Saldo'
        
		IF @pFormato = 'F' 
			SET @SqlSelect = 'INSERT INTO #Result (Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans,Id_Tipo_Cbte,Fecha,Fecha_Venc,Nro_Cuota,Saldo) 
				SELECT C.Id_Cliente, C.Razon_Social,C.Id_Cliente_Ref,F.Id_Trans,F.Id_Tipo_Cbte,F.Fecha,F.Fecha_Venc,CC.Nro_Cuota, (CC.Saldo  * F.Cotizacion) AS Saldo'

		IF @pFormato IN ('P','TP','TPM')
		BEGIN
			SET @SqlSelect = 'INSERT INTO #Result (Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans
								,Id_Tipo_Cbte,Fecha,Fecha_Venc,Nro_Cuota,I.Id_Producto
								,Producto,Saldo) 
				SELECT C.Id_Cliente, C.Razon_Social,C.Id_Cliente_Ref,F.Id_Trans
								,F.Id_Tipo_Cbte,F.Fecha,F.Fecha_Venc,CC.Nro_Cuota,I.Id_Producto
								,P.Descripcion_Detallada,I.Imp_Final * F.Cotizacion * (CC.Saldo / CC.Importe) * (CC.Importe/F.Imp_Total) AS Saldo'

			SET @SqlSelectRec = 'INSERT INTO #Result (Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans,Id_Tipo_Cbte,Fecha,Fecha_Venc,Nro_Cuota,Saldo) 
				SELECT C.Id_Cliente, C.Razon_Social,C.Id_Cliente_Ref,F.Id_Trans,F.Id_Tipo_Cbte,F.Fecha,F.Fecha_Venc,CC.Nro_Cuota, (CC.Saldo  * F.Cotizacion) AS Saldo'
			
		END

		/************************************************ SQL FROM ************************************************/

		SET @SqlFrom = ' FROM Clientes_Ctacte CC
								JOIN Cbtes F ON CC.Id_Trans = F.Id_Trans
								JOIN Cbtes_Tipos TF ON F.Id_Tipo_Cbte = TF.Id_Tipo_Cbte
								JOIN Clientes C ON CC.Id_Cliente = C.Id_Cliente
								JOIN Clientes_Tipos TC ON C.Id_Tipo_Cli = TC.Id_Tipo_Cli
								JOIN #UN U ON TF.Id_Unid_Negocio = U.Id_Unid_Negocio
								JOIN #ACTIVO A ON C.Activo = A.Activo'

		IF @pFormato IN ('P','TP','TPM')
		BEGIN
			SET @SqlFromRec = @SqlFrom
			SET @SqlFrom += '	LEFT JOIN Cbtes_Items I ON F.Id_Trans = I.Id_Trans
								LEFT JOIN Productos P ON I.Id_Producto = P.Id_Producto'

		END

		/************************************************ SQL WHERE ************************************************/

		SET @SqlWhere =	  ' WHERE	CC.Id_Estado_Cbte IN (1,4)
									AND F.Id_Cliente <> 0
									AND TF.Letra <> ''L''
									AND CC.Saldo <> 0  
									AND F.Imp_Total <> 0 '

        IF @pFormato IN ('P','TP','TPM')
			SET @SqlWhereFac +=	  ' AND (TF.Compromete_Factura IN (1,-1) OR TF.Compromete_Recibos IN (1,-1))'
        ELSE
		BEGIN
			SET @SqlWhereFac =	  ' AND TF.Compromete_Factura IN (1,-1) '
			SET @SqlWhereRec =	  ' AND TF.Compromete_Recibos IN (1,-1) '   --los recibos van a parte
		END

		IF(@pFiltroFecha) = 0
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND F.Fecha < ''' + CONVERT(VARCHAR(8),@pFechaHasta+1,112) +'''' 
		ELSE
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND CC.Fecha_Venc < ''' + CONVERT(VARCHAR(8),@pFechaHasta+1,112) +'''' 

		IF(@pId_Cliente) <> 0
		BEGIN
		    IF @Cli_Ref_CtaCte_Agrup <> 0
				SET @SqlWhere += ' AND ( CC.Id_Cliente = ' + CONVERT(VARCHAR(8),@pId_Cliente_Tit) + ' OR C.Id_Cliente_Ref = ' + CONVERT(VARCHAR(8),@pId_Cliente_Tit) +')'
            ELSE
				SET @SqlWhere += ' AND CC.Id_Cliente = ' + CONVERT(VARCHAR(8),@pId_Cliente_Tit) 

        END

			


		/************************************************ GROUP BY ************************************************/
		--SET @SqlGroup = ' GROUP BY C.Id_Cliente, C.Razon_Social, Descripcion_Detallada '


		SET @Sql = @SqlSelect + ' ' + ' '+ @SqlFrom + ' ' + @SqlWhere +' '+ @SqlWhereFac 

		/**********************************************************************************************************/

  		PRINT @Sql
		EXEC(@sql)
		/***********************************************************Formato Producto Cargo los recibos****************/
		IF @pFormato IN ('P','TP','TPM')
		BEGIN
			SET @Sql = @SqlSelectRec + ' ' +' '+ @SqlFromRec + ' ' + @SqlWhere + @SqlWhereRec
			PRINT @Sql
			EXEC(@sql)
		END



		/**********************************************************************************************************/

		IF @Cli_Ref_CtaCte_Agrup <> 0
		BEGIN
			UPDATE #Result SET Id_Cliente_Ref = Id_Cliente WHERE Id_Cliente_Ref IS NULL
			UPDATE #Result SET Id_Cliente_Ref = Id_Cliente WHERE Id_Cliente_Ref = 0
			
			UPDATE #Result SET Id_Cliente = C.Id_Cliente, Razon_Social = C.Razon_Social 
					FROM #Result R JOIN Clientes C ON R.Id_Cliente_Ref = C.Id_Cliente 
					WHERE R.Id_Cliente_Ref <> R.Id_Cliente
		END

		/**/
		IF @pFormato = 'X' -------------------- trae solo las diferencias
		BEGIN
			CREATE TABLE #Result_Det (
				Id_Cliente			INT
				,Razon_Social		VARCHAR(100)
				,Id_Trans			INT
				,Id_Tipo_Cbte		CHAR(4)
				,Fecha				DATETIME
				,Fecha_Venc			DATETIME
				,Cbte_Descrip		VARCHAR(100)
				,Nro_Cuota			INT
				,Id_Producto		VARCHAR(14)
				,Producto			VARCHAR(150)
				,Saldo				DECIMAL(16,2)
				,Id_Cliente_Ref		INT	
				)

			SET @pJsonRecibido = REPLACE(@pJsonRecibido,'"X"','"P"')
			INSERT INTO #Result_Det
				EXEC CPJ_Clientes_Deuda_Resumen @pJsonRecibido


            SELECT Id_Cliente,Razon_Social,SUM(Saldo) AS Saldo INTO #Result_Det_Sum	FROM  #Result_Det	GROUP BY Id_Cliente,Razon_Social
			SELECT Id_Cliente,Razon_Social,SUM(Saldo) AS Saldo INTO #Result_Sum		FROM  #Result		GROUP BY Id_Cliente,Razon_Social

			SELECT  R.Id_Cliente,R.Razon_Social,R.Saldo FROM #Result_Sum R JOIN #Result_Det_Sum RD ON R.Id_Cliente = RD.Id_Cliente
				WHERE R.Saldo - RD.Saldo > 1 OR R.Saldo - RD.Saldo < -1

            DROP TABLE #Result_Det
			DROP TABLE #Result_Det_Sum
            DROP TABLE #Result_Sum 

		END
		ELSE
		BEGIN

			IF @pFormato IN ('','C')
				SELECT  Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans,Id_Tipo_Cbte,Fecha,Fecha_Venc,Cbte_Descrip,Nro_Cuota,Id_Producto,Producto,SUM(Saldo) AS Saldo	
						FROM #Result 
						GROUP BY Id_Cliente,Razon_Social,Id_Cliente_Ref,Id_Trans,Id_Tipo_Cbte,Fecha,Fecha_Venc,Cbte_Descrip,Nro_Cuota,Id_Producto,Producto
						ORDER BY Razon_Social


			IF @pFormato IN ( 'F','P')
				SELECT * FROM #Result ORDER BY Razon_Social,Fecha_Venc

			IF @pFormato = 'TP'
				SELECT  Id_Producto,Producto,SUM(Saldo) AS Saldo	
						FROM #Result 
						WHERE Id_Producto IS NOT NULL
						GROUP BY Producto,Id_Producto
						ORDER BY Saldo DESC

			IF @pFormato = 'TPM'
				SELECT  DATEPART(YYYY,Fecha) AS Anio, DATEPART(MM,Fecha) AS Mes, Id_Producto,Producto,SUM(Saldo) AS Saldo	
						FROM #Result 
						WHERE Id_Producto IS NOT NULL
						GROUP BY DATEPART(YYYY,Fecha) , DATEPART(MM,Fecha) ,Producto,Id_Producto
						ORDER BY DATEPART(YYYY,Fecha) , DATEPART(MM,Fecha) ,Producto,Id_Producto


			--SELECT sum(saldo) FROM #Result 
					 					 
  			DROP TABLE #UN
			DROP TABLE #ACTIVO
			DROP TABLE #Result
		END

		/*



EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":""
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'


EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"F"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"P"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"X"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"P"
									,"Id_Cliente":"48039"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"F"
									,"Id_Cliente":"48039"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

									
EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"TP"
									,"Id_Cliente":"56878"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

EXEC CPJ_Clientes_Deuda_Resumen		'{"FechaDesde":"20000101"
									,"FechaHasta":"20231231"
									,"Id_Unid_Negocio":""
									,"Filtrar_con_saldo":"0"
									,"Clientes_activos":"0"
									,"Formato":"TPM"
									,"Id_Cliente":"0"
									,"FiltroFecha":"0"
									,"Equate":"400"
									,"Usuario":"-1"}'

1035391441.70
1035391441.70
1034676439.70

		*/